unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AHMMails, AHMTIEmails, StdCtrls, ExtCtrls, ComCtrls, AHMMailClass,
  AHMTMailAccount;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Memo1: TMemo;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    AHMPOPMail1: TAHMPOPMail;
    StatusBar1: TStatusBar;
    ListView1: TListView;
    Button1: TButton;
    Label5: TLabel;
    AHMAccountHolder1: TAHMAccountHolder;
    ProgressBar1: TProgressBar;
    procedure Button1Click(Sender: TObject);
    procedure ListView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure AHMPOPMail1BeforeRetrieve(sender: TObject; Index: Word);
    procedure AHMPOPMail1ServerMessage(Sender: TObject; Status,
      Msg: String);
    procedure AHMPOPMail1ServerResponse(Sender: TObject; Status,
      MsgText: String; IsError: Boolean);
    procedure AHMPOPMail1BeforeExecute(Sender: TObject);
    procedure AHMPOPMail1Connect(Sender: TObject; const Server: String;
      Port: Integer);
    procedure AHMPOPMail1Disconnect(Sender: TObject; const Server: String;
      Port: Integer);
    procedure AHMPOPMail1AfterRetrieve(sender: TObject;
      MailMessage: TAHMMessage);
    procedure AHMPOPMail1RetrieveProgress(Sender: TObject; Percent: Word;
      ItemIndex: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  if AHMAccountHolder1.Accounts.Count=0 then
  with TAHMMailAccount.Create(AHMAccountHolder1.Accounts) do
  begin
    AccountName:='Current Account';
    Password:=edit3.Text;
    Username:=Edit2.Text;
    Pop3Server:=edit1.text;
  end else
  with AHMAccountHolder1.Accounts[0] do
  begin
    AccountName:='Current Account';
    Password:=edit3.Text;
    Username:=Edit2.Text;
    Pop3Server:=edit1.text;
  end;
  AHMPopMail1.Execute;
end;

procedure TForm1.ListView1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if ListView1.Selected<>nil then
  begin
    Memo1.Lines.Text:=AHMPopMail1.Messages[ListView1.Selected.Index].Message.Text;
  end;
end;

procedure TForm1.AHMPOPMail1BeforeRetrieve(sender: TObject; Index: Word);
begin
  Statusbar1.SimpleText:='Retrieving Mail ... ';
end;

procedure TForm1.AHMPOPMail1ServerMessage(Sender: TObject; Status,
  Msg: String);
begin
  Statusbar1.SimpleText:=Status+'-'+Msg;
end;

procedure TForm1.AHMPOPMail1ServerResponse(Sender: TObject; Status,
  MsgText: String; IsError: Boolean);
begin
  if IsError then
     Statusbar1.SimpleText:='Error'+Status+'-'+MsgText
  else Statusbar1.SimpleText:=Status+'-'+MsgText;
end;

procedure TForm1.AHMPOPMail1BeforeExecute(Sender: TObject);
begin
  ProgressBar1.Position:=0;
end;

procedure TForm1.AHMPOPMail1Connect(Sender: TObject; const Server: String;
  Port: Integer);
begin
  Statusbar1.SimpleText:='Connecting to '+Server;
end;

procedure TForm1.AHMPOPMail1Disconnect(Sender: TObject;
  const Server: String; Port: Integer);
begin
 if AHMPopMail1.Messages.count>0 then
  Statusbar1.SimpleText:='Disconnecting from '+Server
 else Statusbar1.SimpleText:='No Messages waiting on '+Server
end;

procedure TForm1.AHMPOPMail1AfterRetrieve(sender: TObject;
  MailMessage: TAHMMessage);
begin
 with ListView1.Items.Add do
 begin
   Caption:=MailMessage.FromName;
   SubItems.add(MailMessage.Subject);
 end;
 ProgressBar1.Position:=0;
end;

procedure TForm1.AHMPOPMail1RetrieveProgress(Sender: TObject;
  Percent: Word; ItemIndex: Integer);
begin
  ProgressBar1.Position:=Percent;
end;

end.
